(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     16458,        635]*)
(*NotebookOutlinePosition[     17305,        662]*)
(*  CellTagsIndexPosition[     17261,        658]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "SansSerif"],
  PageWidth->WindowWidth,
  ScriptMinSize->7,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->7,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "SansSerifPrintout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontFamily->"Helvetica",
  FontSize->8,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  DefaultNewCellStyle->"Text",
  DefaultDuplicateCellStyle->"Text",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["H1"],
  CellMargins->{{12, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"H1",
  CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H4", 0}, {"H5", 0}, {"H6", 0}},
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["H1", "SansSerif"],
  FontSize->30,
  FontWeight->"Bold"],

Cell[StyleData["H1", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->30],

Cell[StyleData["H1", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->26]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H2"],
  CellMargins->{{12, Inherited}, {10, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  CounterIncrements->"H2",
  CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H5", 0}, {"H6", 0}},
  FontSize->24,
  FontWeight->"Bold"],

Cell[StyleData["H2", "SansSerif"],
  FontSize->20],

Cell[StyleData["H2", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->20],

Cell[StyleData["H2", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H3"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"H3",
  CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H6", 0}},
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["H3", "SansSerif"],
  FontSize->16],

Cell[StyleData["H3", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->16],

Cell[StyleData["H3", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H4"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"H4",
  CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["H4", "SansSerif"],
  FontSize->12],

Cell[StyleData["H4", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->12],

Cell[StyleData["H4", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H5"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"H5",
  CounterAssignments->{{"H6", 0}},
  FontWeight->"Bold"],

Cell[StyleData["H5", "SansSerif"]],

Cell[StyleData["H5", "Printout"],
  CellMargins->{{2, 10}, {8, 10}}],

Cell[StyleData["H5", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["H6"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"H6",
  FontSize->10,
  FontWeight->"Bold"],

Cell[StyleData["H6", "SansSerif"],
  FontSize->9,
  FontTracking->"Extended"],

Cell[StyleData["H6", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->8.5],

Cell[StyleData["H6", "SansSerifPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->7.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Body"],
  CellMargins->{{14, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Body"],

Cell[StyleData["Body", "SansSerif"]],

Cell[StyleData["Body", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}],

Cell[StyleData["Body", "SansSerifPrintout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LI"],
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{23, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"LI"],

Cell[StyleData["LI", "SansSerif"],
  CellMargins->{{25, 10}, {7, 7}}],

Cell[StyleData["LI", "Printout"],
  CellMargins->{{12, 2}, {6, 6}}],

Cell[StyleData["LI", "SansSerifPrintout"],
  CellMargins->{{12, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "SansSerif"],
  FontSize->12],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9],

Cell[StyleData["Input", "SansSerifPrintout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "SansSerif"],
  FontSize->12],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "SansSerifPrintout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "SansSerif"],
  FontSize->12],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "SansSerif"],
  FontSize->12],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8],

Cell[StyleData["Print", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "SansSerif"],
  FontSize->12],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9],

Cell[StyleData["Graphics", "SansSerifPrintout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "SansSerif"]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "SansSerifPrintout"],
  FontSize->7,
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "SansSerif"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "SansSerif"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "SansSerif"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnLink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "SansSerif"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "SansSerif"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "SansSerif"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "SansSerifPrintout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0 Beta 3",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{495, 312},
WindowMargins->{{10, Automatic}, {Automatic, 4}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 122, 4, 70, 33, 0, "StyleData", "All", "SansSerif"],
Cell[2239, 73, 140, 4, 70, 32, 0, "StyleData", "All", "Printout"],
Cell[2382, 79, 175, 5, 70, 41, 0, "StyleData", "All", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2594, 89, 35, 0, 38, "Section"],
Cell[2632, 91, 101, 3, 70, "Text"],
Cell[2736, 96, 494, 13, 70, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3267, 114, 38, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[3330, 118, 316, 8, 112, 21, 0, "StyleData", "H1", "All",
  CounterIncrements->"H1",
  CounterAssignments->{{"H2", 0}, {"H3", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H4", 0}, {"H5", 0}, {"H6", 0}}],
Cell[3649, 128, 72, 2, 70, 34, 0, "StyleData", "H1", "SansSerif"],
Cell[3724, 132, 85, 2, 70, 33, 0, "StyleData", "H1", "Printout"],
Cell[3812, 136, 94, 2, 70, 42, 0, "StyleData", "H1", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3943, 143, 306, 8, 63, 21, 0, "StyleData", "H2", "All",
  CounterIncrements->"H2",
  CounterAssignments->{{"H3", 0}, {"H4", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H5", 0}, {"H6", 0}}],
Cell[4252, 153, 50, 1, 70, 34, 0, "StyleData", "H2", "SansSerif"],
Cell[4305, 156, 85, 2, 70, 33, 0, "StyleData", "H2", "Printout"],
Cell[4393, 160, 94, 2, 70, 42, 0, "StyleData", "H2", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4524, 167, 295, 8, 56, 21, 0, "StyleData", "H3", "All",
  CounterIncrements->"H3",
  CounterAssignments->{{"H4", 0}, {"H5", 0}, {"Equation", 0}, {"Figure", 0}, {
      "H6", 0}}],
Cell[4822, 177, 50, 1, 70, 34, 0, "StyleData", "H3", "SansSerif"],
Cell[4875, 180, 84, 2, 70, 33, 0, "StyleData", "H3", "Printout"],
Cell[4962, 184, 93, 2, 70, 42, 0, "StyleData", "H3", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5092, 191, 279, 7, 52, 21, 0, "StyleData", "H4", "All",
  CounterIncrements->"H4",
  CounterAssignments->{{"H5", 0}, {"H6", 0}, {"Equation", 0}, {"Figure", 0}}],

Cell[5374, 200, 50, 1, 70, 34, 0, "StyleData", "H4", "SansSerif"],
Cell[5427, 203, 84, 2, 70, 33, 0, "StyleData", "H4", "Printout"],
Cell[5514, 207, 93, 2, 70, 42, 0, "StyleData", "H4", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5644, 214, 220, 6, 51, 21, 0, "StyleData", "H5", "All",
  CounterIncrements->"H5",
  CounterAssignments->{{"H6", 0}}],
Cell[5867, 222, 34, 0, 70, 34, 0, "StyleData", "H5", "SansSerif"],
Cell[5904, 224, 68, 1, 70, 33, 0, "StyleData", "H5", "Printout"],
Cell[5975, 227, 77, 1, 70, 42, 0, "StyleData", "H5", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6089, 233, 201, 6, 48, 21, 0, "StyleData", "H6", "All",
  CounterIncrements->"H6"],
Cell[6293, 241, 77, 2, 70, 34, 0, "StyleData", "H6", "SansSerif"],
Cell[6373, 245, 85, 2, 70, 33, 0, "StyleData", "H6", "Printout"],
Cell[6461, 249, 94, 2, 70, 42, 0, "StyleData", "H6", "SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6604, 257, 39, 0, 38, "Section"],

Cell[CellGroupData[{
Cell[6668, 261, 110, 3, 70, 23, 0, "StyleData", "Body", "All",
  CounterIncrements->"Body"],
Cell[6781, 266, 36, 0, 70, 36, 0, "StyleData", "Body", "SansSerif"],
Cell[6820, 268, 68, 1, 70, 35, 0, "StyleData", "Body", "Printout"],
Cell[6891, 271, 77, 1, 70, 44, 0, "StyleData", "Body", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7005, 277, 145, 4, 70, 21, 0, "StyleData", "LI", "All",
  CounterIncrements->"LI"],
Cell[7153, 283, 69, 1, 70, 34, 0, "StyleData", "LI", "SansSerif"],
Cell[7225, 286, 67, 1, 70, 33, 0, "StyleData", "LI", "Printout"],
Cell[7295, 289, 76, 1, 70, 42, 0, "StyleData", "LI", "SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7420, 296, 42, 0, 38, "Section"],
Cell[7465, 298, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[7738, 307, 467, 14, 41, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[8208, 323, 53, 1, 70, 37, 0, "StyleData", "Input", "SansSerif"],
Cell[8264, 326, 85, 2, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[8352, 330, 94, 2, 70, 45, 0, "StyleData", "Input", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8483, 337, 454, 13, 47, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[8940, 352, 54, 1, 70, 38, 0, "StyleData", "Output", "SansSerif"],
Cell[8997, 355, 86, 2, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[9086, 359, 95, 2, 70, 46, 0, "StyleData", "Output", "SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9218, 366, 501, 14, 44, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[9722, 382, 55, 1, 70, 39, 0, "StyleData", "Message", "SansSerif"],
Cell[9780, 385, 138, 3, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[9921, 390, 147, 3, 70, 47, 0, "StyleData", "Message", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10105, 398, 498, 14, 44, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[10606, 414, 53, 1, 36, 37, 0, "StyleData", "Print", "SansSerif"],
Cell[10662, 417, 109, 2, 32, 36, 0, "StyleData", "Print", "Printout"],
Cell[10774, 421, 118, 2, 32, 45, 0, "StyleData", "Print", "SansSerifPrintout"]

}, Closed]],

Cell[CellGroupData[{
Cell[10929, 428, 440, 12, 44, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[11372, 442, 56, 1, 36, 40, 0, "StyleData", "Graphics", "SansSerif"],
Cell[11431, 445, 137, 3, 34, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[11571, 450, 146, 3, 34, 48, 0, "StyleData", "Graphics", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11754, 458, 128, 4, 42, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[11885, 464, 41, 0, 70, 41, 0, "StyleData", "CellLabel", "SansSerif"],
Cell[11929, 466, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[12062, 472, 91, 2, 70, 49, 0, "StyleData", "CellLabel", 
"SansSerifPrintout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12202, 480, 35, 0, 38, "Section"],
Cell[12240, 482, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[12449, 490, 302, 8, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[12754, 500, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "SansSerif"],
Cell[12798, 502, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[12908, 506, 116, 2, 70, 49, 0, "StyleData", "Hyperlink", 
"SansSerifPrintout"]
}, Closed]],
Cell[13039, 511, 104, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[13168, 518, 316, 8, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[13487, 528, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "SansSerif"],
Cell[13534, 530, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"],
Cell[13647, 534, 119, 2, 70, 52, 0, "StyleData", "MainBookLink", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13803, 541, 337, 9, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[14143, 552, 42, 0, 70, 42, 0, "StyleData", "AddOnsLink", "SansSerif"],
Cell[14188, 554, 107, 2, 70, 40, 0, "StyleData", "AddOnLink", "Printout"],
Cell[14298, 558, 116, 2, 70, 49, 0, "StyleData", "AddOnLink", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14451, 565, 345, 9, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[14799, 576, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "SansSerif"],
Cell[14846, 578, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"],
Cell[14959, 582, 119, 2, 70, 52, 0, "StyleData", "RefGuideLink", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15115, 589, 328, 8, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[15446, 599, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"SansSerif"],
Cell[15499, 601, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"],
Cell[15618, 605, 125, 2, 70, 58, 0, "StyleData", "GettingStartedLink", 
"SansSerifPrintout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15780, 612, 332, 8, 70, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[16115, 622, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"SansSerif"],
Cell[16170, 624, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"],
Cell[16291, 628, 127, 2, 70, 60, 0, "StyleData", "OtherInformationLink", 
"SansSerifPrintout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

